# pWarden: Process Behavior Guardian

pWarden learns what "normal" looks like for every process on your system, then watches for deviations in real-time. It's not asking "is this bad?" but rather "is this unusual for this specific process?"

## Overview

Traditional security tools either look for known bad patterns (signatures) or monitor resources without context. They miss the subtle deviations that indicate a breach, compromised process, or insider threat.

pWarden establishes behavioral baselines automatically, then continuously monitors for anomalies. When a web server suddenly spawns a shell, a database connects to unexpected ports, or any process deviates from its established pattern, pWarden alerts you.

## Key Features

- **Automatic Baseline Learning**: Observes processes during a learning period to establish normal behavior patterns
- **Real-time Anomaly Detection**: Monitors network connections, file access, and resource usage
- **Context-Aware**: Understands that "unusual" differs for each process
- **Multiple Alert Channels**: Supports stdout, log file, and syslog
- **Lightweight**: Uses Linux proc filesystem for efficient monitoring

## Building

### Prerequisites

- GCC compiler
- jansson library (JSON parsing)
- Linux system with proc filesystem

### Install Dependencies

On Debian/Ubuntu:
```bash
sudo apt-get install build-essential libjansson-dev
```

On Fedora/RHEL:
```bash
sudo dnf install gcc jansson-devel
```

### Compile

```bash
make
```

### Install

```bash
sudo make install
```

This installs `pwarden` to `/usr/local/bin/`.

## Usage

### Basic Usage

Run pWarden in the foreground to see output:
```bash
pwarden
```

Run as a daemon:
```bash
pwarden -d
```

### Learning Mode

By default, pWarden runs in learning mode for 24 hours. During this time, it:
- Discovers all running processes
- Collects behavioral data (network connections, file access, resource usage)
- Builds statistical models for each process
- Saves baselines to `~/.pwarden/baselines/`

### Monitoring Mode

After the learning period, pWarden switches to monitoring mode:
- Continuously monitors all processes
- Compares current behavior against learned baselines
- Alerts when anomalies are detected

## Configuration

Create a configuration file at `~/.pwarden/config.json` or `/etc/pwarden.conf`:

```json
{
  "baseline_dir": "/home/user/.pwarden/baselines",
  "logfile_path": "/home/user/.pwarden/pwarden.log",
  "learning_period_seconds": 86400,
  "monitoring_interval_seconds": 5,
  "resource_threshold": 3.0,
  "excluded_processes": [
    "kernel",
    "systemd"
  ],
  "alerts": {
    "stdout": true,
    "logfile": true,
    "syslog": true
  },
  "daemonize": false
}
```

### Configuration Options

- `baseline_dir`: Directory where baseline JSON files are stored
- `logfile_path`: Path to log file for alerts
- `learning_period_seconds`: Duration of learning mode (default: 86400 = 24 hours)
- `monitoring_interval_seconds`: How often to scan processes (default: 5 seconds)
- `resource_threshold`: Standard deviation multiplier for resource anomaly detection (default: 3.0)
- `excluded_processes`: Array of process names to exclude from monitoring
- `alerts`: Object controlling alert destinations
  - `stdout`: Enable console output
  - `logfile`: Enable file logging
  - `syslog`: Enable syslog integration
- `daemonize`: Run as daemon (can also use `-d` flag)

## Baseline Format

Baselines are stored as JSON files in the baseline directory. Each file is named `{process_name}_{pid}.json`:

```json
{
  "pid": 1234,
  "name": "nginx",
  "executable": "/usr/sbin/nginx",
  "baseline_established": "2024-01-15T10:00:00Z",
  "network": {
    "tcp_connections": [
      {
        "dest_ip": "0.0.0.0",
        "dest_port": 80,
        "frequency": 0.95
      }
    ],
    "udp_connections": []
  },
  "resources": {
    "cpu_mean": 2.5,
    "cpu_std": 1.2,
    "memory_mean": 52428800,
    "memory_std": 10485760
  },
  "file_patterns": [
    "/var/log/nginx/*",
    "/etc/nginx/*"
  ]
}
```

## Anomaly Detection

pWarden detects the following types of anomalies:

1. **Network Anomalies**: Unknown connections to destinations/ports not seen during learning
2. **Resource Anomalies**: CPU or memory usage spikes beyond normal thresholds
3. **File Access Anomalies**: Access to files outside learned patterns
4. **Process Spawn Anomalies**: Unexpected child process creation (future feature)

## Alert Format

Alerts are formatted as:

```
[2024-01-15 10:30:45] ANOMALY DETECTED
  Type: NETWORK_UNKNOWN_CONNECTION
  PID: 1234
  Process: nginx
  Severity: 0.80
  Details: Unknown T connection to 192.168.1.100:4444
```

## Signal Handling

- `SIGTERM` / `SIGINT`: Graceful shutdown
- `SIGHUP`: Reload configuration

## Security Considerations

- pWarden may need elevated privileges to access `/proc` filesystem for all processes
- Baseline files contain sensitive information about process behavior
- Ensure proper file permissions on baseline directory and log files
- Consider running as a dedicated user with appropriate permissions

## Limitations

- Linux-only (relies on proc filesystem)
- CPU usage tracking is simplified (would need more sophisticated tracking for accurate percentages)
- File pattern matching is basic (could be enhanced with regex or glob patterns)
- Process spawn detection not yet implemented

## Development

### Project Structure

```
pWarden/
├── src/
│   ├── main.c                 # Main daemon loop
│   ├── process_tracker.c     # Process discovery
│   ├── behavior_collector.c   # Data collection
│   ├── baseline.c            # Baseline management
│   ├── anomaly_detector.c    # Anomaly detection
│   ├── alert.c               # Alerting system
│   ├── config.c              # Configuration
│   └── json_utils.c          # JSON utilities
├── include/                  # Header files
├── Makefile
└── README.md
```

### Building from Source

```bash
make clean
make
```

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Author

**Eric Cain**  
Contact: ecain@ecain.org

## Version

Current version: **0.9**

## Contributing

[Contributing guidelines if applicable]

