#ifndef ALERT_H
#define ALERT_H

#include "anomaly_detector.h"
#include <stdbool.h>

typedef struct {
    bool stdout_enabled;
    bool logfile_enabled;
    bool syslog_enabled;
    char *logfile_path;
} AlertConfig;

int alert_init(AlertConfig *config);
void alert_cleanup(void);
int alert_send(Anomaly *anomaly);
int alert_send_to_stdout(Anomaly *anomaly);
int alert_send_to_logfile(Anomaly *anomaly, const char *logfile_path);
int alert_send_to_syslog(Anomaly *anomaly);

#endif /* ALERT_H */

