#ifndef ANOMALY_DETECTOR_H
#define ANOMALY_DETECTOR_H

#include "baseline.h"
#include "behavior_collector.h"

typedef enum {
    ANOMALY_NETWORK_UNKNOWN_CONNECTION,
    ANOMALY_RESOURCE_CPU_SPIKE,
    ANOMALY_RESOURCE_MEMORY_SPIKE,
    ANOMALY_FILE_UNUSUAL_ACCESS,
    ANOMALY_PROCESS_SPAWN
} AnomalyType;

typedef struct {
    AnomalyType type;
    pid_t pid;
    char *process_name;
    char *details;
    time_t timestamp;
    double severity;  // 0.0 to 1.0
} Anomaly;

Anomaly* anomaly_detector_check(ProcessBaseline *baseline, BehaviorSnapshot *snapshot, double threshold);
void anomaly_free(Anomaly *anomaly);
const char* anomaly_type_to_string(AnomalyType type);
int anomaly_detector_check_network(ProcessBaseline *baseline, BehaviorSnapshot *snapshot, Anomaly **anomalies, size_t *count);
int anomaly_detector_check_resources(ProcessBaseline *baseline, BehaviorSnapshot *snapshot, double threshold, Anomaly **anomalies, size_t *count);
int anomaly_detector_check_files(ProcessBaseline *baseline, BehaviorSnapshot *snapshot, Anomaly **anomalies, size_t *count);

#endif /* ANOMALY_DETECTOR_H */

