#ifndef BASELINE_H
#define BASELINE_H

#include <sys/types.h>
#include <time.h>
#include <jansson.h>
#include "behavior_collector.h"

typedef struct {
    char *dest_ip;
    uint16_t dest_port;
    double frequency;  // 0.0 to 1.0
    uint64_t count;
} NetworkBaseline;

typedef struct {
    NetworkBaseline *tcp_connections;
    NetworkBaseline *udp_connections;
    size_t tcp_count;
    size_t udp_count;
    size_t tcp_capacity;
    size_t udp_capacity;
} NetworkBaselineData;

typedef struct {
    double cpu_mean;
    double cpu_std;
    double memory_mean;
    double memory_std;
    uint64_t sample_count;
} ResourceBaseline;

typedef struct {
    char **patterns;
    size_t count;
    size_t capacity;
} FileBaseline;

typedef struct {
    pid_t pid;
    char *name;
    char *executable;
    time_t baseline_established;
    NetworkBaselineData network;
    ResourceBaseline resources;
    FileBaseline files;
} ProcessBaseline;

typedef struct {
    ProcessBaseline *baselines;
    size_t count;
    size_t capacity;
} BaselineStore;

BaselineStore* baseline_init(void);
void baseline_destroy(BaselineStore *store);
int baseline_load(BaselineStore *store, const char *baseline_dir);
int baseline_save(BaselineStore *store, const char *baseline_dir);
ProcessBaseline* baseline_find(BaselineStore *store, pid_t pid);
ProcessBaseline* baseline_find_by_name(BaselineStore *store, const char *name, const char *executable);
ProcessBaseline* baseline_create_new(BaselineStore *store, pid_t pid, const char *name, const char *executable);
int baseline_add_observation(ProcessBaseline *baseline, BehaviorSnapshot *snapshot);
int baseline_finalize(ProcessBaseline *baseline);
void process_baseline_free(ProcessBaseline *baseline);

#endif /* BASELINE_H */

