#ifndef BEHAVIOR_COLLECTOR_H
#define BEHAVIOR_COLLECTOR_H

#include <sys/types.h>
#include <stdint.h>

typedef struct {
    char *dest_ip;
    uint16_t dest_port;
    uint16_t local_port;
    char protocol;  // 'T' for TCP, 'U' for UDP
} NetworkConnection;

typedef struct {
    NetworkConnection *connections;
    size_t count;
    size_t capacity;
} NetworkData;

typedef struct {
    char **files;
    size_t count;
    size_t capacity;
} FileAccessData;

typedef struct {
    double cpu_percent;
    uint64_t memory_rss;  // Resident Set Size in bytes
    uint64_t memory_vsize; // Virtual Size in bytes
} ResourceData;

typedef struct {
    pid_t pid;
    NetworkData network;
    FileAccessData files;
    ResourceData resources;
    time_t timestamp;
} BehaviorSnapshot;

BehaviorSnapshot* behavior_collector_collect(pid_t pid);
void behavior_snapshot_free(BehaviorSnapshot *snapshot);
int behavior_collector_get_network(pid_t pid, NetworkData *network);
int behavior_collector_get_files(pid_t pid, FileAccessData *files);
int behavior_collector_get_resources(pid_t pid, ResourceData *resources);

#endif /* BEHAVIOR_COLLECTOR_H */

