#ifndef CONFIG_H
#define CONFIG_H

#include <stdbool.h>
#include <time.h>

typedef struct {
    char *config_path;
    char *baseline_dir;
    char *logfile_path;
    time_t learning_period_seconds;
    unsigned int monitoring_interval_seconds;
    double resource_threshold;  // Multiplier for std deviation
    char **excluded_processes;
    size_t excluded_count;
    bool stdout_enabled;
    bool logfile_enabled;
    bool syslog_enabled;
    bool daemonize;
} Config;

Config* config_load(const char *config_path);
void config_free(Config *config);
Config* config_default(void);
bool config_is_excluded(Config *config, const char *process_name);

#endif /* CONFIG_H */

