#ifndef JSON_UTILS_H
#define JSON_UTILS_H

#include <jansson.h>
#include <stdbool.h>

json_t* json_utils_load_file(const char *filename);
int json_utils_save_file(const char *filename, json_t *json);
json_t* json_utils_get_string_safe(json_t *json, const char *key);
json_t* json_utils_get_number_safe(json_t *json, const char *key);
json_t* json_utils_get_array_safe(json_t *json, const char *key);
json_t* json_utils_get_object_safe(json_t *json, const char *key);
bool json_utils_get_string_value(json_t *json, const char *key, char **value);
bool json_utils_get_int_value(json_t *json, const char *key, int *value);
bool json_utils_get_double_value(json_t *json, const char *key, double *value);

#endif /* JSON_UTILS_H */

