#ifndef PROCESS_TRACKER_H
#define PROCESS_TRACKER_H

#include <sys/types.h>
#include <stdbool.h>

typedef struct {
    pid_t pid;
    pid_t ppid;
    char *name;
    char *executable;
    char *cmdline;
    time_t first_seen;
    time_t last_seen;
} ProcessInfo;

typedef struct ProcessNode {
    ProcessInfo *process;
    struct ProcessNode *next;
} ProcessNode;

typedef struct {
    ProcessNode *head;
    size_t count;
} ProcessList;

ProcessList* process_tracker_init(void);
void process_tracker_destroy(ProcessList *list);
int process_tracker_scan(ProcessList *list);
ProcessInfo* process_tracker_find(ProcessList *list, pid_t pid);
void process_tracker_remove(ProcessList *list, pid_t pid);
void process_info_free(ProcessInfo *info);

#endif /* PROCESS_TRACKER_H */

